#ifndef SCIP_HANDLER_H
#define SCIP_HANDLER_H

/*!
  \file
  \brief SCIP プロトコル処理

  \author Satofumi KAMIMURA

  $Id: ScipHandler.h 1669 2010-02-04 08:28:27Z satofumi $
*/

#include <vector>
#include <string>
#include <memory>


namespace qrk
{
  class Connection;
  class RangeFinderParameter;


  //! SCIP プロトコル処理
  class ScipHandler
  {
  public:
    ScipHandler(void);
    ~ScipHandler(void);

    static bool checkSum(char* buffer, int size, char actual_sum,
                         bool print_error = true);

    const char* what(void) const;

    long timestamp(void) const;

    void setConnection(Connection* connection);
    Connection* connection(void) const;
    bool connect(const char* device, long baudrate);

    bool versionLines(std::vector<std::string>& lines);
    bool loadParameter(RangeFinderParameter& parameter);

    int send(const char data[], int size);
    int receive(char data[], int max_size, int timeout);
    bool receiveData(std::vector<long>& data, long* timestamp);

    void laserOn(void);
    void laserOff(void);

    static long encode(const char* data, size_t size);

  private:
    ScipHandler(const ScipHandler& rhs);
    ScipHandler& operator = (const ScipHandler& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;
  };
}

#endif /* !SCIP_HANDLER_H */
