#ifndef QRK_OBJECT_MAP_UTILS_H
#define QRK_OBJECT_MAP_UTILS_H

/*!
  \file
  \brief 環境マップの補助関数

  \author Satofumi KAMIMURA

  $Id$
*/

#include "Position.h"
#include "pole_t.h"
#include "line_t.h"
#include <vector>


namespace qrk
{
  class ObjectMap;
  class ObjectMapBuffer;


  Angle angleFromPoles(const ObjectMap* global_map,
                       const ObjectMap* current_map);

  Point<long> pointFromPoles(const ObjectMap* global_map,
                             const ObjectMap* current_map);

  extern void registerPoles(ObjectMapBuffer& map_buffer,
                            const ObjectMap& global_map,
                            const std::vector<pole_t>& poles, long timestamp);
  extern void registerLines(ObjectMapBuffer& map_buffer,
                            const std::vector<line_t>& lines, long timestamp);

  extern void mergeStaticObject(ObjectMap& global_map,
                                ObjectMapBuffer& map_buffer,
                                size_t buffer_msec = 1000);

  extern void updateObjectPosition(ObjectMap* current_map,
                                   const Position<long>& position,
                                   const Position<long>& previous_position);
}

#endif /* !QRK_OBJECT_MAP_UTILS_H */
