/*!
  \file
  \brief 環境マップのバッファ

  登録した物体が、移動しているかを判定するために用いる。

  \author Satofumi KAMIMURA

  $Id: ObjectMapBuffer.cpp 1495 2009-11-03 11:27:55Z satofumi $
*/

#include "ObjectMapBuffer.h"
#include "ObjectMap.h"
#include <deque>

using namespace qrk;
using namespace std;


struct ObjectMapBuffer::pImpl
{
  deque<ObjectMap*> map_buffer_;
  size_t last_id_;


  pImpl(void) : last_id_(0)
  {
  }
};


ObjectMapBuffer::ObjectMapBuffer(void) : pimpl(new pImpl)
{
}


ObjectMapBuffer::~ObjectMapBuffer(void)
{
}


bool ObjectMapBuffer::empty(void) const
{
  return pimpl->map_buffer_.empty();
}


size_t ObjectMapBuffer::size(void) const
{
  return pimpl->map_buffer_.size();
}


ObjectMap* ObjectMapBuffer::at(size_t index) const
{
  return pimpl->map_buffer_[index];
}


ObjectMap* ObjectMapBuffer::front(void) const
{
  return pimpl->map_buffer_.front();
}


ObjectMap* ObjectMapBuffer::back(void) const
{
  return pimpl->map_buffer_.back();
}


void ObjectMapBuffer::pop_back(void)
{
  delete pimpl->map_buffer_.back();
  pimpl->map_buffer_.pop_back();
}


long ObjectMapBuffer::timestamp(size_t index) const
{
  return pimpl->map_buffer_[index]->timestamp();
}


size_t ObjectMapBuffer::index(long timestamp) const
{
  if (pimpl->map_buffer_.empty()) {
    pimpl->map_buffer_.push_back(new ObjectMap);
    return 0;
  }

  // 先頭に存在するか、存在しないか、のどちらかのみとして処理する
  if (pimpl->map_buffer_.front()->timestamp() != timestamp) {
    ObjectMap* map = new ObjectMap;
    map->setTimestamp(timestamp);
    pimpl->map_buffer_.push_front(map);
  }
  return 0;
}


size_t ObjectMapBuffer::lastId(void) const
{
  return ++pimpl->last_id_;
}
