#ifndef QRK_LOCK_H
#define QRK_LOCK_H

/*!
  \file
  \brief ロッククラス

  \author Satofumi KAMIMURA

  $Id: Lock.h 1811 2010-04-30 16:12:05Z satofumi $
*/

#include "ConditionVariable.h"


namespace qrk
{
    //! ロッククラス
    class Lock
    {
    public:
        Lock(void);
        ~Lock(void);


        //! ロック
        void lock(void);


        //! ロック
        bool tryLock(void);


        //! アンロック
        void unlock(void);

    private:
        friend class ConditionalVariable;
        friend bool ConditionVariable::wait(Lock* lock, int timeout);

        Lock(const Lock& rhs);
        Lock& operator = (const Lock& rhs);

        //void* operator new (size_t);
        //void* operator new[] (size_t);

        struct pImpl;
        const std::auto_ptr<pImpl> pimpl;
    };
}

#endif /* !QRK_LOCK_GUARD_H */
