#ifndef QRK_C_URG_T_H
#define QRK_C_URG_T_H

/*!
  \file
  \brief Structure for URG control

  \author Satofumi KAMIMURA

  $Id: urg_t.h 1989 2012-05-18 00:32:36Z satofumi $
*/

#include "urg_parameter_t.h"
#include "serial_t.h"


/*!
  \brief Constant for URG control
*/
typedef enum {
  UrgLaserOff = 0,
  UrgLaserOn,
  UrgLaserUnknown,
} urg_laser_state_t;


/*!
  \brief Structure for URG control
*/
typedef struct {

  serial_t serial_;              /*!< Structure of serial control */
  int errno_;                    /*!< Store error number */
  urg_parameter_t parameters_;   /*!< Sensor parameter */

  int skip_lines_;   /*!< Number of lines to be skipped in one scan */

  char remain_data_[3];
  int remain_byte_;

} urg_t;

#endif /* !QRK_C_URG_T_H */
