/*!
  \example cpp/scan_simple.cpp

  \brief 「物体までの距離を測る」サンプル

  \author Satofumi KAMIMURA

  $Id: scan_simple.cpp 1397 2009-10-11 04:21:25Z satofumi $
*/

#include <qrk_main.h>
#include <mUrgDevice.h>
#include <MarkerManager.h>
#include <vector>

using namespace qrk;
using namespace std;


namespace
{
  void printCsv(const vector<long>& data)
  {
    for (vector<long>::const_iterator it = data.begin();
         it != data.end(); ++it) {
      cout << *it << ", ";
    }
    cout << endl;
  }
}


int main(int argc, char *argv[])
{
  static_cast<void>(argc);
  static_cast<void>(argv);

  // 接続
  mUrgDevice urg;
  if (! urg.connect("/dev/ttyACM0")) {
    cout << "BeegoDrive::connect: " << urg.what() << endl;
    return 1;
  }

  // 観測した距離データを表示
  enum { CaptureTimes = 10 };
  vector<long> data;
  for (size_t i = 0; i < CaptureTimes; ++i) {
    urg.requestData();
    if (urg.receiveData(data)) {
      printCsv(data);
    }
  }

  return 0;
}
