/*!
  \example cpp/move_rotate.cpp

  \brief 「その場で回転する」サンプル

  \author Satofumi KAMIMURA

  $Id: move_rotate.cpp 1688 2010-02-11 23:10:16Z satofumi $
*/

#include <qrk_main.h>
#include <mBeegoDrive.h>
#include <delay.h>

using namespace qrk;
using namespace std;


int main(int argc, char *argv[])
{
  static_cast<void>(argc);
  static_cast<void>(argv);

  // 接続
  mBeegoDrive run;
  if (! run.connect("/dev/ttyUSB0")) {
    cout << "BeegoDrive::connect: " << run.what() << endl;
    return 1;
  }

  //////////////////////////////////////////////////////////////////////
  // -360 [deg] だけ相対回転する
  run.spin(deg(-360));
  while (! run.isStable()) {
    delay(100);
  }

  delay(1000);

  //////////////////////////////////////////////////////////////////////
  // 180 [deg] の向きに回転する
  run.rotate(deg(90));
  while (! run.isStable()) {
    delay(100);
  }

  return 0;
}
