/*!
  \file
  \brief motor_ctrol.c のシミュレーション用の実装

  \author Satofumi KAMIMURA

  $Id: motor_control.cpp 1687 2010-02-11 05:26:50Z satofumi $
*/

#include "motor_control.h"
#include "encoder_control.h"
#include "BeegoModel.h"

using namespace qrk;


namespace
{
  BeegoModel* model_ = NULL;
}


void motor_setModel(BeegoModel* model)
{
  model_ = model;
}


void motor_initialize(int id, motor_t *motor)
{
  motor->id = id;
}


void motor_reset(motor_t *motor)
{
  static_cast<void>(motor);

  // 実装しない
}


void motor_set(int id, MotorMode mode)
{
  static_cast<void>(id);
  static_cast<void>(mode);

  // 実装しない
}


void motor_setVelocity(motor_t *motor, int count_per_msec,
                       int encoder_count)
{
  static_cast<void>(encoder_count);

  // encoder_count に関係なく、指定速度でモータを回転させる
  char id = motor->id;
  model_->setMotorVelocity(id, count_per_msec);
}
