#ifndef QRK_SIMULATION_WINDOW_H
#define QRK_SIMULATION_WINDOW_H

/*!
  \file
  \brief シミュレータ用のウィンドウ

  \author Satofumi KAMIMURA

  $Id: SimulationWindow.h 1392 2009-10-10 10:59:39Z satofumi $
*/

#include "ui_SimulationWindowForm.h"
#include "ExecutionType.h"


namespace qrk
{
  typedef int MainFunction(int argc, char *argv[]);


  //! 引数の処理クラス
  class ArgsInformation
  {
  public:
    bool simulation_;
    ExecutionType::Type type_;


    ArgsInformation(void) : simulation_(false), type_(ExecutionType::RealDevice)
    {
    }
  };


  //! シミュレータ用のウィンドウ管理
  class SimulationWindow : public QMainWindow, private Ui::SimulationWindowForm
  {
    Q_OBJECT;

    SimulationWindow(const SimulationWindow& rhs);
    SimulationWindow& operator = (const SimulationWindow& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  private slots:
    void quitHandler(void);
    void closeEvent(QCloseEvent* event);
    void playPressed(void);
    void pausePressed(void);
    void moreFasterPressed(void);
    void moreSlowerPressed(void);
    void redraw(void);
    void aboutApplication(void);
    void ticksControlClosed(void);
    void ticksControlChecked(bool checked);
    void wireframeChecked(bool checked);

  public:
    SimulationWindow(MainFunction* program, int argc, char *argv[]);
    ~SimulationWindow(void);

    /*!
      \brief 引数を解析して動作モードを決定する

      \retval true 正常
      \retval false プログラムを終了させる場合
    */
    static bool parseArgs(ArgsInformation& args, int argc, char *argv[]);
  };
}

#endif /* !QRK_SIMULATION_WINDOW_H */
