#ifndef QRK_LOG_NAME_HOLDER_H
#define QRK_LOG_NAME_HOLDER_H

/*!
  \file
  \brief ログ名の管理

  \author Satofumi KAMIMURA

  $Id: LogNameHolder.h 1412 2009-10-14 21:29:28Z satofumi $
*/

#include <memory>
#include <string>


namespace qrk
{
  /*!
    \brief ログ名の管理
  */
  class LogNameHolder
  {
  public:
    ~LogNameHolder(void);
    static LogNameHolder* object(void);

    std::string name(const char* baseName);

  private:
    LogNameHolder(void);
    LogNameHolder(const LogNameHolder& rhs);
    LogNameHolder& operator = (const LogNameHolder& rhs);

    struct pImpl;
    const std::auto_ptr<pImpl> pimpl;
  };
}

#endif /* !QRK_LOG_NAME_HOLDER_H */
