#ifndef QRK_EVENT_SCHEDULER_H
#define QRK_EVENT_SCHEDULER_H

/*!
  \file
  \brief イベントのスケジュール管理

  \author Satofumi KAMIMURA

  $Id: EventScheduler.h 1528 2009-11-17 23:32:01Z satofumi $
*/

#include <ode/ode.h>
#include <cstddef>


namespace qrk
{
  class Device;
  class ConditionVariable;
  class Lock;


  //! イベントの管理クラス
  class EventScheduler
  {
  public:
    EventScheduler(void);
    ~EventScheduler(void);

    Lock* lock(void);
    Lock* tryLock(void);
    void unlock(void);

    void start(void);
    void terminate(void);

    long ticks(void) const;
    void play(void);
    void pause(void);
    void moreFaster(void);
    void moreSlower(void);

    void registerDevice(Device* device);
    void removeDevice(Device* device);
    bool registerDelayEvent(ConditionVariable* condition, size_t msec,
                            bool absolute_msec = false);

    void setLaser(long* buffer, dGeomID laser_id);

  private:
    EventScheduler(const EventScheduler& rhs);
    EventScheduler& operator = (const EventScheduler& rhs);

    struct pImpl;
    pImpl* pimpl;
  };
}

#endif /* !QRK_EVENT_SCHEDULER_H */
