#ifndef QRK_CAMERA_VIEW_MANAGER_H
#define QRK_CAMERA_VIEW_MANAGER_H

/*!
  \file
  \brief カメラ視点の制御クラス

  \author Satofumi KAMIMURA

  $Id: CameraViewManager.h 1414 2009-10-14 23:14:02Z satofumi $
*/

namespace qrk
{
  class Angle;


  //! カメラの視点制御クラス
  class CameraViewManager
  {
  public:
    CameraViewManager(void);
    ~CameraViewManager(void);

    bool updated(void) const;

    void setInitialView(double x, double y, double z,
                        const Angle& x_axis,
                        const Angle& y_axis,
                        const Angle& z_axis);
    void initializeView(void);

    void setBaseView(double x, double y, double z,
                     const Angle& x_axis,
                     const Angle& y_axis,
                     const Angle& z_axis);

    void setView(double x, double y, double z,
                 const Angle& x_axis, const Angle& y_axis, const Angle& z_axis);
    void view(double& x, double& y, double& z,
              Angle& x_axis, Angle& y_axis, Angle& z_axis);
    void setScale(double zoom);
    double scale(void) const;

  private:
    CameraViewManager(const CameraViewManager& rhs);
    CameraViewManager& operator = (const CameraViewManager& rhs);

    struct pImpl;
    pImpl* pimpl;
  };
}

#endif /* !QRK_CAMERA_VIEW_MANAGER_H */
