/*!
  \file
  \brief Lua への Range Finder モジュール登録

  \author Satofumi KAMIMURA

  $Id: luabindRangeFinder.cpp 1811 2010-04-30 16:12:05Z satofumi $
*/

#include "luabindRangeFinder.h"
#include "mUrgDevice.h"
#include "mUrgDistance.h"
#include <luabind/luabind.hpp>

using namespace qrk;
using namespace luabind;


void qrk::luabindRangeFinder(lua_State* L)
{
    module(L)
        [
         class_<mUrgDevice, Coordinate>("UrgDevice")
         .def(constructor<>())
         .def("what", &mUrgDevice::what)
         .def("connect", &mUrgDevice::connect)
         .def("disconnect", &mUrgDevice::disconnect)
         .def("requestData", &mUrgDevice::requestData)
         .def("receiveData",
              (bool(mUrgDevice::*)(void)) &mUrgDevice::receiveData),

         class_<mUrgDistance, Coordinate>("UrgDistance")
         .def(constructor<>())
         .def("what", &mUrgDistance::what)
         .def("connect", &mUrgDistance::connect)
         .def("disconnect", &mUrgDistance::disconnect)
         .def("requestData", &mUrgDistance::requestData)
         .def("receiveData",
              (bool(mUrgDistance::*)(void)) &mUrgDistance::receiveData)
         .def("at", &mUrgDistance::at)
         ];
}
