-- チャットサンプル (クライアント)
-- Satofumi KAMIMURA
-- $Id: chat_client.lua 809 2009-05-07 00:43:49Z satofumi $

local offset = 16
local font_height = 24

-- メッセージ描画用のフォント
local font = Font("../../gui/samples/font.ttf", font_height, true)


local screen = Screen()
local screen_rect = screen:rect()

local back_color = Color(0.0, 0.0, 0.4, 1.0)
local width = screen_rect.w - (offset * 2)
local message_height = font_height + offset
local log_height = screen_rect.h - (message_height + (offset * 3))

-- チャットメッセージ欄の作成
local log_rect = Rect(0, 0, width, log_height)
local log_back_surface = ColorSurface(log_rect, back_color)
local log_back = Label(log_back_surface)
log_back:setPosition(Point(offset, offset))

-- メッセージ入力欄の作成
local message_rect = Rect(0, 0, width, message_height)
local message_back_surface = ColorSurface(message_rect, back_color)
local message_back = Label(message_back_surface)
message_back:setPosition(Point(offset, screen_rect.h - message_height - offset))

-- 受信メッセージの描画用
local chat_message_rect = Rect(0, 0, width - offset, log_height - offset)
local chat_message = ChatMessage(font, chat_message_rect)
chat_message:setPosition(Point(offset * 1.5, offset * 1.5))

-- カーソルの作成
local prompt_surface = ColorSurface(Rect(0, 0, 12, 2),
                                    Color(1.0, 1.0, 1.0, 1.0))
local prompt = Label(prompt_surface)
local base_y = screen_rect.h - message_height - offset / 2.0


-- コンポーネント登録
function createForm(layer)

   layer:push_back(log_back)
   layer:push_back(message_back)
   layer:push_front(chat_message)
   layer:push_front(prompt)
end


-- 入力メッセージ描画用
local input_text_surface = nil
local input_text = nil

function updateInputMessage(layer, text)

   layer:remove(input_text)
   local position = Point(offset * 1.5, base_y)
   if #text > 0 then
      -- 入力文字列の描画
      input_text_surface = TextSurface(font, text)
      input_text = Label(input_text_surface)

      position = Point(offset * 1.5, base_y)
      input_text:setPosition(position)
      layer:push_front(input_text)

      position.x = position.x + input_text_surface:rect().w + 2
   end
   position.y = base_y + font_height;

   -- カーソルの描画
   prompt:setPosition(position)
end


-- チャット用メッセージの追加
function addMessage(message)

   chat_message:print(message)
   chat_message:newline()
end