#!/usr/bin/ruby
# monitor ログからのタイミングデータ除去
# Satofumi KAMIMURA
# $Id: stripTimingData.rb 541 2009-02-03 02:28:38Z satofumi $

LF = 0x0a.chr

if ARGV.size != 1
  print "usage:\n\t" + __FILE__ + "<log file>\n"
  exit
end
LogFile = ARGV[0]

# 出力ファイル名の作成
basename = File.basename(LogFile, '.log')
send_file = basename + '_send.txt'
recv_file = basename + '_recv.txt'

send_fd = File.open(send_file, "wb")
recv_fd = File.open(recv_file, "wb")
# !!! ファイルが生成できたかの確認をすべき

# 送受信データの生成
File.open(LogFile) { |io|
  while first_line = io.gets(LF)
    if first_line != nil
      first_line.chomp!
    end

    tokens = first_line.split(/[\s,#]+/)
    if (tokens.size != 3)
      # コメントがなければ、無視
      io.gets(LF)
      next
    end

    comment = tokens[2]
    if ! ((comment == "send()") || (comment == "recv()"))
      # send, recv のとき以外は、処理を行わない
      io.gets(LF)
      next
    end

    data_size = tokens[1].to_i
    data = io.read(data_size)

    # データの格納
    if comment == "send()"
      send_fd.write(data)
    else
      recv_fd.write(data)
    end

    # 改行の読み飛ばし
    io.read(1)
  end
}

send_fd.close()
recv_fd.close()
