/*!
  \example ublas_sample.cpp

  Boost uBLAS の使用サンプル

  \author Satofumi KAMIMURA

  $Id: ublas_sample.cpp 1811 2010-04-30 16:12:05Z satofumi $
*/

#include <boost/numeric/ublas/matrix.hpp>
//#include <boost/numeric/ublas/vector.hpp>
#include <boost/numeric/ublas/io.hpp>
#include <iostream>

using namespace boost::numeric;
using namespace std;


int main(int argc, char *argv[])
{
    static_cast<void>(argc);
    static_cast<void>(argv);

    ublas::matrix<double> a(2, 2);
    ublas::matrix<double> b(2, 2);

    a(0, 0) = 1.0;
    a(0, 1) = 0.0;
    a(1, 0) = 0.0;
    a(1, 1) = 1.0;

    b(0, 0) = 1.0;
    b(0, 1) = 2.0;
    b(1, 0) = 3.0;
    b(1, 1) = 4.0;

    cout << a << endl
         << b << endl
         << prod(a, b) << endl;

    ublas::matrix<double> c(4, 4);
    ublas::matrix<double> d(1, 4);
    c(0, 0) = 1.0;
    c(1, 1) = 1.0;
    c(2, 2) = 1.0;
    c(3, 3) = 1.0;

    d(0, 0) = 2.0;
    d(0, 1) = 3.0;
    d(0, 2) = 4.0;
    d(0, 3) = 5.0;

    ublas::matrix<double> e = prod(d, c);

    cout << d << endl;

    return 0;
}
