/*!
  \examples registerSingleton.cpp
  \brief シングルトンの登録サンプル

  \author Satofumi KAMIMURA

  $Id: registerSingleton.cpp 935 2009-05-29 00:30:03Z satofumi $
*/

#include "SingletonClass.h"
#include "LuaHandler.h"
#include "luabindInit.h"
#include <luabind/luabind.hpp>

using namespace qrk;
using namespace luabind;


namespace
{
  void luabindSingleton(lua_State* L)
  {
    module(L)
      [
       class_<SingletonClass>("SingletonClass")
       .def("hello", &SingletonClass::hello),

       // シングルトンを取得する関数として登録
       def("SingletonClass_object", &SingletonClass::object)
       ];

    // Lua に直接登録する例
    object lua_global = globals(L);
    lua_global["SingletonClass"] = SingletonClass::object();
  }
}


int main(int argc, char *argv[])
{
  static_cast<void>(argc);
  static_cast<void>(argv);

  lua_State* L = luabindInit();
  luabindSingleton(L);
  return LuaHandler::dofile(L, "use_singleton.lua");
}
