/*!
  \file
  \brief Lua への BeegoDrive モジュール登録

  \author Satofumi KAMIMURA

  $Id: luabindBeegoDrive.cpp 1811 2010-04-30 16:12:05Z satofumi $
*/

#include "luabindBeegoDrive.h"
#include "mBeegoDrive.h"
#include <luabind/luabind.hpp>

using namespace qrk;
using namespace luabind;


void qrk::luabindBeegoDrive(lua_State* L)
{
    module(L)
        [
         class_<mBeegoDrive>("mBeegoDrive")
         .def(constructor<>())
         .def("what", &mBeegoDrive::what)
         .def("connect", &mBeegoDrive::connect)
         .def("position", &mBeegoDrive::position)
         .def("followLine", (void(mBeegoDrive::*)(long, long, const Angle&,
                                                  const Coordinate*))
              &mBeegoDrive::followLine)
         .def("stopLine", (void(mBeegoDrive::*)(long, long, const Angle&,
                                                const Coordinate*))
              &mBeegoDrive::stopLine)
         .def("followCircle",
              (void(mBeegoDrive::*)(long, long, long, const Coordinate*))
              &mBeegoDrive::followCircle)
         .def("spin", &mBeegoDrive::spin)
         .def("rotate", &mBeegoDrive::rotate)
         .def("stop", &mBeegoDrive::stop)
         .def("isStable", &mBeegoDrive::isStable)
         .def("setWheelVelocity", &mBeegoDrive::setWheelVelocity)
         ];
}
