#ifndef QRK_RUBI_PARSE_H
#define QRK_RUBI_PARSE_H

/*!
  \file
  \brief ルビ位置のパース

  \author Satofumi KAMIMURA

  $Id: rubi_parse.h 1822 2010-05-11 16:16:40Z satofumi $
*/

#include <vector>
#include <cstddef>


namespace qrk
{
    typedef struct
    {
        size_t kanji_first;
        size_t kanji_size;
        size_t rubi_first;
        size_t rubi_size;
    } rubi_t;


    extern bool rubi_parse(std::vector<rubi_t>& rubi_positions,
                           const char* text, const char* kana_only);
}

#endif /* !QRK_RUBI_PARSE_H */
