/*!
  \file
  \brief Utf8 のテスト

  \author Satofumi KAMIMURA

  $Id: TestUtf8.cpp 1811 2010-04-30 16:12:05Z satofumi $
*/

#include "TestUtf8.h"
#include "Utf8.h"

using namespace qrk;
using namespace std;


CPPUNIT_TEST_SUITE_REGISTRATION(TestUtf8);
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(TestUtf8, "TestUtf8");


void TestUtf8::emptyTest(void)
{
    Utf8 some_text("abc");
    CPPUNIT_ASSERT_EQUAL(false, some_text.empty());

    Utf8 empty_text("");
    CPPUNIT_ASSERT_EQUAL(true, empty_text.empty());
}


void TestUtf8::sizeTest(void)
{
    // 日本語なし
    Utf8 ascii_text("abc");
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(3), ascii_text.size());

    // 日本語あり
    Utf8 jp_text("あいう");
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(3), jp_text.size());

    // 混合文字
    Utf8 mix_text("abあcいう");
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(6), mix_text.size());
}


void TestUtf8::chTest(void)
{
    // 日本語なし
    Utf8 ascii_text("abc");
    CPPUNIT_ASSERT_EQUAL(static_cast<unsigned short>('a'), ascii_text[0]);
    CPPUNIT_ASSERT_EQUAL(static_cast<unsigned short>('b'), ascii_text[1]);
    CPPUNIT_ASSERT_EQUAL(static_cast<unsigned short>('c'), ascii_text[2]);

    // 日本語あり
    Utf8 jp_text("あいう");
    CPPUNIT_ASSERT_EQUAL(Utf8("あ")[0], jp_text[0]);
    CPPUNIT_ASSERT_EQUAL(Utf8("い")[0], jp_text[1]);
    CPPUNIT_ASSERT_EQUAL(Utf8("う")[0], jp_text[2]);

    // 混合文字
    Utf8 mix_text("abあcいう");
    CPPUNIT_ASSERT_EQUAL(static_cast<unsigned short>('a'), mix_text[0]);
    CPPUNIT_ASSERT_EQUAL(static_cast<unsigned short>('b'), mix_text[1]);
    CPPUNIT_ASSERT_EQUAL(Utf8("あ")[0], mix_text[2]);
    CPPUNIT_ASSERT_EQUAL(static_cast<unsigned short>('c'), mix_text[3]);
    CPPUNIT_ASSERT_EQUAL(Utf8("い")[0], mix_text[4]);
    CPPUNIT_ASSERT_EQUAL(Utf8("う")[0], mix_text[5]);
}


void TestUtf8::c_strTest(void)
{
    Utf8 actual = Utf8("a");
    CPPUNIT_ASSERT_EQUAL(string("a"), actual.toStdString());

    actual = Utf8("あ");
    CPPUNIT_ASSERT_EQUAL(string("あ"), actual.toStdString());

    actual = Utf8("あい");
    CPPUNIT_ASSERT_EQUAL(string("あい"), actual.toStdString());

    actual = Utf8("");
    CPPUNIT_ASSERT_EQUAL(string(""), actual.toStdString());
}


void TestUtf8::pop_backTest(void)
{
    Utf8 actual = Utf8("あい");
    actual.pop_back();
    CPPUNIT_ASSERT_EQUAL(string("あ"), actual.toStdString());

    actual.pop_back();
    CPPUNIT_ASSERT_EQUAL(string(""), actual.toStdString());

    actual.pop_back();
    CPPUNIT_ASSERT_EQUAL(string(""), actual.toStdString());


    actual = Utf8("わっg");
    actual.pop_back();
    CPPUNIT_ASSERT_EQUAL(string("わっ"), actual.toStdString());

    actual = Utf8(actual.toStdString());
    CPPUNIT_ASSERT_EQUAL(string("わっ"), actual.toStdString());
}


void TestUtf8::substrTest(void)
{
    Utf8 actual = Utf8("あいう");
    CPPUNIT_ASSERT_EQUAL(string("あい"), actual.substr(0, 2).toStdString());

    actual = Utf8("あいう");
    CPPUNIT_ASSERT_EQUAL(string("あいう"), actual.substr(0, 3).toStdString());

    actual = Utf8("あいう");
    CPPUNIT_ASSERT_EQUAL(string("あ"), actual.substr(0, 1).toStdString());

    actual = Utf8("あいう");
    CPPUNIT_ASSERT_EQUAL(string("いう"), actual.substr(1, 2).toStdString());

    actual = Utf8("あいう");
    CPPUNIT_ASSERT_EQUAL(string("う"), actual.substr(2, 3).toStdString());

    actual = Utf8("aiう");
    CPPUNIT_ASSERT_EQUAL(string("う"), actual.substr(2, 1).toStdString());

    actual = Utf8("あiう");
    CPPUNIT_ASSERT_EQUAL(string("iう"), actual.substr(1, 2).toStdString());

    actual = Utf8("");
    CPPUNIT_ASSERT_EQUAL(string(""), actual.substr(0, 0).toStdString());
}
