/*!
  \file
  \brief RubiParse.cpp のテスト

  \author Satofumi KAMIMURA

  $Id: TestRubiParse.cpp 1825 2010-05-15 10:50:09Z satofumi $
*/

#include "TestRubiParse.h"
#include "rubi_parse.h"

using namespace qrk;
using namespace std;

CPPUNIT_TEST_SUITE_REGISTRATION(TestRubiParse);
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(TestRubiParse, "TestRubiParse");


void TestRubiParse::rubiParseTest(void)
{
    vector<rubi_t> rubi;

    rubi.clear();
    rubi_parse(rubi, "む", "む");
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(0), rubi.size());

    rubi.clear();
    rubi_parse(rubi, "無", "む");
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(1), rubi.size());

    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(0), rubi[0].kanji_first);
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(1), rubi[0].kanji_size);
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(0), rubi[0].rubi_first);
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(1), rubi[0].rubi_size);


    rubi.clear();
    rubi_parse(rubi, "無し", "なし");
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(1), rubi.size());

    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(0), rubi[0].kanji_first);
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(1), rubi[0].kanji_size);
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(0), rubi[0].rubi_first);
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(1), rubi[0].rubi_size);


    rubi.clear();
    rubi_parse(rubi, "よい水", "よいみず");
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(1), rubi.size());

    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(2), rubi[0].kanji_first);
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(1), rubi[0].kanji_size);
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(2), rubi[0].rubi_first);
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(2), rubi[0].rubi_size);


    rubi.clear();
    rubi_parse(rubi, "よい水だ", "よいみずだ");
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(1), rubi.size());

    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(2), rubi[0].kanji_first);
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(1), rubi[0].kanji_size);
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(2), rubi[0].rubi_first);
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(2), rubi[0].rubi_size);


    rubi.clear();
    rubi_parse(rubi, "秋の田の", "あきのたの");
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(2), rubi.size());

    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(0), rubi[0].kanji_first);
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(1), rubi[0].kanji_size);
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(0), rubi[0].rubi_first);
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(2), rubi[0].rubi_size);

    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(2), rubi[1].kanji_first);
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(1), rubi[1].kanji_size);
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(3), rubi[1].rubi_first);
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(1), rubi[1].rubi_size);


    rubi.clear();
    rubi_parse(rubi, "あふ坂の関", "あふさかのせき");
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(2), rubi.size());

    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(2), rubi[0].kanji_first);
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(1), rubi[0].kanji_size);
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(2), rubi[0].rubi_first);
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(2), rubi[0].rubi_size);

    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(4), rubi[1].kanji_first);
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(1), rubi[1].kanji_size);
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(5), rubi[1].rubi_first);
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(2), rubi[1].rubi_size);


    rubi.clear();
    rubi_parse(rubi, "今日は卵を食べました。", "きょうはたまごをたべました。");
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(3), rubi.size());

    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(0), rubi[0].kanji_first);
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(2), rubi[0].kanji_size);
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(0), rubi[0].rubi_first);
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(3), rubi[0].rubi_size);

    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(3), rubi[1].kanji_first);
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(1), rubi[1].kanji_size);
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(4), rubi[1].rubi_first);
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(3), rubi[1].rubi_size);

    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(5), rubi[2].kanji_first);
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(1), rubi[2].kanji_size);
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(8), rubi[2].rubi_first);
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(1), rubi[2].rubi_size);


    rubi.clear();
    rubi_parse(rubi, "法性寺入道前関白太政大臣",
               "ほうしょうじのにゅうどうさきのかんぱくだいじょうだいじん");
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(1), rubi.size());
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(0), rubi[0].kanji_first);
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(12), rubi[0].kanji_size);
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(0), rubi[0].rubi_first);
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(28), rubi[0].rubi_size);


    rubi.clear();
    bool ret = rubi_parse(rubi, "吉野のさとに", "よしののさとに");
    CPPUNIT_ASSERT_EQUAL(true, ret);

    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(1), rubi.size());
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(0), rubi[0].kanji_first);
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(2), rubi[0].kanji_size);
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(0), rubi[0].rubi_first);
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(3), rubi[0].rubi_size);
}
