/*!
  \file
  \brief convertToRoman.cpp のテスト

  \author Satofumi KAMIMURA

  $Id: TestConvertToRoman.cpp 1811 2010-04-30 16:12:05Z satofumi $
*/

#include "TestConvertToRoman.h"
#include "convertToRoman.h"

using namespace qrk;
using namespace std;

CPPUNIT_TEST_SUITE_REGISTRATION(TestConvertToRoman);
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(TestConvertToRoman, "TestConvertToRoman");


void TestConvertToRoman::convertTest(void)
{
    CPPUNIT_ASSERT_EQUAL(string("a"), convertToRoman("あ"));
    CPPUNIT_ASSERT_EQUAL(string("aka"), convertToRoman("あか"));
    CPPUNIT_ASSERT_EQUAL(string("ga"), convertToRoman("が"));
    CPPUNIT_ASSERT_EQUAL(string("nba"), convertToRoman("んば"));
    CPPUNIT_ASSERT_EQUAL(string("sixya"), convertToRoman("しゃ"));
    CPPUNIT_ASSERT_EQUAL(string("a"), convertToRoman("a"));
}


void TestConvertToRoman::currentInputTest(void)
{
    CPPUNIT_ASSERT_EQUAL(string("a"), convertToRoman("あ", "a"));
    CPPUNIT_ASSERT_EQUAL(string("sha"), convertToRoman("しゃ", "sh"));
    CPPUNIT_ASSERT_EQUAL(string("sya"), convertToRoman("しゃ", "sy"));
    CPPUNIT_ASSERT_EQUAL(string("sixya"), convertToRoman("しゃ", "ss"));
}
