/*!
  \example simpleScreen.cpp
  \brief 画面の作成サンプル

  \author Satofumi KAMIMURA

  $Id: simpleScreen.cpp 1814 2010-05-03 07:57:38Z satofumi $
*/

#include <SDL.h>
#include <cstdlib>


namespace
{
    void exitAndError(void)
    {
        printf("error: %s\n", SDL_GetError());
        exit(1);
    }
}


int main(int argc, char *argv[])
{
    // "-f" が引数に渡されたらフルスクリーン画面にする
    Uint32 flags = 0;
    for (int i = 1; i < argc; ++i) {
        if (! strcmp(argv[i], "-f")) {
            flags |= SDL_FULLSCREEN;
        }
    }

    // SDL の初期化
    if (SDL_Init(SDL_INIT_VIDEO) < 0) {
        exitAndError();
    }

    // 画面の作成
    int bpp = 0;                  // デフォルトのピクセル深度を用いる
    SDL_Surface* screen = SDL_SetVideoMode(640, 480, bpp, flags);
    if (! screen) {
        exitAndError();
    }

    // 待機
    SDL_Delay(1000);

    // SDL の終了処理
    SDL_Quit();

    return 0;
}
