/*!
  \example rubiDraw.cpp

  \author Satofumi KAMIMURA

  $Id: rubiDraw.cpp 1823 2010-05-11 22:11:47Z satofumi $
*/

#include "Screen.h"
#include "Font.h"
#include "TextRubiFadeSurface.h"

using namespace qrk;


int main(int argc, char *argv[])
{
    Screen screen;
    screen.show(SDL_OPENGL);

    // フォントの読み出し
    const char* font_file = (argc <= 1) ? "font.ttf" : argv[1];
    Font font(font_file, 32);
    Font rubi_font(font_file, 16);

    // ルビを含む文字列の描画
#if 0
    TextRubiFadeSurface surface(font, "今日は、卵を食べました。",
                                rubi_font, "きょうは、たまごをたべました。");
#else
    //TextRubiFadeSurface surface(font, "夜半", rubi_font, "よは");
TextRubiFadeSurface surface(font, "法性寺入道前関白太政大臣", rubi_font, "ほうしょうじのにゅうどうさきのかんぱくだいじょうだいじん");
#endif
    Rect<long> dest_rect = surface.rect();
    dest_rect.x += 100;

    // 描画した文字列のをフェードさせる
    for (size_t j = 0; j < 1; ++j) {
        for (size_t i = 0; i <= 100; ++i) {
            screen.clear();
            surface.setFadePercent(i);
            surface.draw(NULL, &dest_rect);
            SDL_GL_SwapBuffers();
            SDL_Delay(10);
        }
    }
    SDL_Delay(100);

    return 0;
}
