/*!
  \example TextFadeSurafce.cpp の動作サンプル

  \author Satofumi KAMIMURA

  $Id: fadeText.cpp 1814 2010-05-03 07:57:38Z satofumi $
*/

#include "Screen.h"
#include "Font.h"
#include "TextFadeSurface.h"

using namespace qrk;


int main(int argc, char *argv[])
{
    Screen screen;
    screen.show(SDL_OPENGL);

    // フォントの読み出し
    const char* font_file = (argc <= 1) ? "font.ttf" : argv[1];
    Font font(font_file, 32);

    // 文字列の描画
    TextFadeSurface surface(font, "This is sample text.");
    Rect<long> dest_rect = surface.rect();

    // 描画した文字列のをフェードさせる
    for (size_t j = 0; j < 1; ++j) {
        for (size_t i = 0; i <= 100; ++i) {
            screen.clear();
            surface.setFadePercent(i);
            surface.draw(NULL, &dest_rect);
            SDL_GL_SwapBuffers();
            SDL_Delay(10);
        }
    }
    SDL_Delay(100);

    return 0;
}
