/*!
  \example colorSurfaceSample.cpp ColorSurface の描画サンプル

  \author Satofumi KAMIMURA

  $Id: drawColorSurface.cpp 1814 2010-05-03 07:57:38Z satofumi $
*/

#include "Screen.h"
#include "ColorSurface.h"
#include "ImageSurface.h"
#include "Color.h"

using namespace qrk;
//using namespace std;


int main(int argc, char *argv[])
{
    static_cast<void>(argc);
    static_cast<void>(argv);

    Screen screen;
    screen.show(Screen::OpenGL);
    screen.clear();

    Surface* surface_1st =
        new ColorSurface(Rect<long>(0, 0, 100, 100), Color(1.0, 0.0, 0.0, 1.0));
    Rect<long> dest_1st(0, 0, 100, 100);
    surface_1st->draw(NULL, &dest_1st);

    Surface* surface_2nd = new ImageSurface("cross_blue.bmp");
    Rect<long> dest_2nd = surface_2nd->rect();
    dest_2nd.x = 125;
    dest_2nd.y = 125;
    surface_2nd->draw(NULL, &dest_2nd);

    Surface* surface_3rd =
        new ColorSurface(Rect<long>(0, 0, 100, 100), Color(0.4, 0.4, 1.0, 0.8));
    Rect<long> dest_3rd(50, 50, 100, 100);
    surface_3rd->draw(NULL, &dest_3rd);

    // 描画内容を反映させる
    SDL_GL_SwapBuffers();
    SDL_Delay(1000);

    return 0;
}
