/*!
  \example chatMessageSample.cpp
  \brief ChatMessageComponent の動作サンプル

  \author Satofumi KAMIMURA

  $Id: chatMessageSample.cpp 1814 2010-05-03 07:57:38Z satofumi $
*/

#include "ChatMessage.h"
#include "Screen.h"
#include "LayerManager.h"
#include "Layer.h"
#include "Font.h"
#include "ColorSurface.h"
#include "Label.h"
#include "CallbackEvent.h"
#include "EventUtils.h"
#include "delay.h"
#include <string>

using namespace qrk;
using namespace std;


int main(int argc, char *argv[])
{
    string font_file = "font.ttf";
    if (argc >= 2) {
        font_file = argv[1];
    }

    Screen screen;
    screen.show(SDL_OPENGL);

    LayerManager layer_manager;
    Layer layer;
    layer_manager.push_back(&layer);

    // 指定フォントからの文字列を作成
    enum {
        FontSize = 20,
    };
    Font font(font_file.c_str(), FontSize);

    Rect<long> screen_rect = screen.rect();
    Rect<long> message_rect = screen_rect;
    message_rect.h = message_rect.h / 4;
    ChatMessage message(font, message_rect);
    message.setPosition(Point<long>(0, screen_rect.h - (screen_rect.h / 4)));

    layer.push_front(&message);

    message.print("メッセージの表示サンプル");
    message.newline();

    message.print("２行目のメッセージ表示");
    message.newline();

    CallbackEvent quit_event;
    setQuitEvent(&quit_event);
    layer_manager.insertEvent(&quit_event);

    while (! quit_event.isActive()) {

        layer_manager.updateEvent();

        screen.clear();
        layer_manager.draw();
        layer_manager.swap();
        delay(10);
    }
    return 0;
}
