#ifndef QRK_SCREEN_H
#define QRK_SCREEN_H

/*!
  \file
  \brief 画面の生成

  \author Satofumi KAMIMURA

  $Id: Screen.h 1811 2010-04-30 16:12:05Z satofumi $
*/

#include "Rect.h"
#include <SDL.h>


namespace qrk
{
    class Color;


    //! 画面の生成
    class Screen
    {
    public:
        static const Uint32 OpenGL = SDL_OPENGL;

        Screen(void);
        ~Screen(void);

        const char* what(void) const;

        bool show(Uint32 flags = 0);

        Rect<long> rect(void) const;

        //! 変更は show(), setFullscreen(), toggleFullscreen() 呼び出し時に反映される
        void setWindowSize(size_t width, size_t height);

        //! 変更は show(), setFullscreen(), toggleFullscreen() 呼び出し時に反映される
        void setWindowBpp(size_t bpp);

        void setCaption(const char* caption, const char* icon_caption);
        void setIcon(const SDL_Surface* icon, const Uint8* mask = NULL);

        void setFullscreen(bool on = true);
        bool isFullscreen(void) const;
        void toggleScreen(void);

        void showCursor(bool show_cursor);
        bool isShowCursor(void) const;

        void setClearColor(const Color& color);

#if ! defined(NO_OPENGL)
        //! SDL_OPENGL が指定されていないと動作しない
        void clear(void);

        static void enter2D(void);
        static void leave2D(void);

        static void setClipArea(const Rect<long>& area);
        static void disableClipArea(void);
#endif

    private:
        Screen(const Screen& rhs);
        Screen& operator = (const Screen& rhs);

        struct pImpl;
        pImpl* pimpl;
    };
}

#endif /* !QRK_SCREEN_H */
