#ifndef QRK_LAYER_H
#define QRK_LAYER_H

/*!
  \file
  \brief 描画レイヤー

  \author Satofumi KAMIMURA

  $Id: Layer.h 1811 2010-04-30 16:12:05Z satofumi $
*/

#include "LayerInterface.h"
#include <memory>


namespace qrk
{
    class Component;


    //! 描画レイヤー
    class Layer : public LayerInterface
    {
    public:
        Layer(void);
        ~Layer(void);

        void clear(void);
        void push_front(Component* component);
        void push_back(Component* component);
        void remove(Component* component);
        void setAlpha(float alpha);
        float alpha(void) const;
        void draw(void);

    private:
        Layer(const Layer& rhs);
        Layer& operator = (const Layer& rhs);

        struct pImpl;
        std::auto_ptr<pImpl> pimpl;
    };
}

#endif /* !QRK_LAYER_H */
