#ifndef QRK_IMAGE_SURFACE_H
#define QRK_IMAGE_SURFACE_H

/*!
  \file
  \brief 画像サーフェスの作成

  \author Satofumi KAMIMURA

  $Id: ImageSurface.h 1811 2010-04-30 16:12:05Z satofumi $
*/

#include "Surface.h"
#include <memory>


namespace qrk
{
    //! 画像サーフェスの作成
    class ImageSurface : public Surface
    {
    public:
        explicit ImageSurface(const char* file, bool transparent = false);
        ~ImageSurface(void);

        bool isValid(void) const;
        Rect<long> rect(void) const;
        void setAlpha(float alpha);
        float alpha(void) const;
        void setRotateAngle(const Angle& angle);
        void draw(const Rect<long>* src, const Rect<long>* dest);

    private:
        ImageSurface(const ImageSurface& rhs);
        ImageSurface& operator = (const ImageSurface& rhs);

        struct pImpl;
        std::auto_ptr<pImpl> pimpl;
    };
}

#endif /* !QRK_IMAGE_SURFACE_H */
