#ifndef QRK_FILL_SURFACE_H
#define QRK_FILL_SURFACE_H

/*!
  \file
  \brief 塗りつぶしサーフェス

  \author Satofumi KAMIMURA

  $Id: FillSurface.h 1811 2010-04-30 16:12:05Z satofumi $
*/

#include "Surface.h"
#include <memory>


namespace qrk
{
    //! 単色サーフェス
    class FillSurface : public Surface
    {
    public:
        explicit FillSurface(const Rect<long>& rect, Surface& surface);
        ~FillSurface(void);

        bool isValid(void) const;
        Rect<long> rect(void) const;
        void setAlpha(float alpha);
        float alpha(void) const;
        void setRotateAngle(const Angle& angle);
        void draw(const Rect<long>* src, const Rect<long>* dest);

    private:
        FillSurface(const FillSurface& rhs);
        FillSurface& operator = (const FillSurface& rhs);

        struct pImpl;
        std::auto_ptr<pImpl> pimpl;
    };
}

#endif /* !QRK_FILL_SURFACE_H */
