/*!
  \file
  \brief 塗りつぶしサーフェス

  \author Satofumi KAMIMURA

  $Id: FillSurface.cpp 1811 2010-04-30 16:12:05Z satofumi $
*/

#include "FillSurface.h"
#include "Screen.h"

using namespace qrk;


struct FillSurface::pImpl
{
    Rect<long> rect_;
    Rect<long> surface_rect_;
    Surface& surface_;


    pImpl(const Rect<long>& rect, Surface& surface)
        : rect_(rect), surface_rect_(surface.rect()), surface_(surface)
    {
    }
};


FillSurface::FillSurface(const Rect<long>& rect, Surface& surface)
    : pimpl(new pImpl(rect, surface))
{
}


FillSurface::~FillSurface(void)
{
}


bool FillSurface::isValid(void) const
{
    return pimpl->surface_.isValid();
}


Rect<long> FillSurface::rect(void) const
{
    return pimpl->rect_;
}


void FillSurface::setAlpha(float alpha)
{
    pimpl->surface_.setAlpha(alpha);
}


float FillSurface::alpha(void) const
{
    return pimpl->surface_.alpha();
}


void FillSurface::setRotateAngle(const Angle& angle)
{
    pimpl->surface_.setRotateAngle(angle);
}


void FillSurface::draw(const Rect<long>* src, const Rect<long>* dest)
{
    if ((! dest) || (! pimpl->surface_.isValid())) {
        return;
    }

    Screen::setClipArea(*dest);

    // !!! src を考慮する

    long w = pimpl->surface_rect_.w;
    long h = pimpl->surface_rect_.h;
    for (long y = 0; y <= dest->h; y += h) {
        for (long x = 0; x <= dest->w; x += w) {
            Rect<long> sub_dest(dest->x + x, dest->y + y, w, h);
            pimpl->surface_.draw(src, &sub_dest);
        }
    }

    Screen::disableClipArea();
}
