#ifndef QRK_COMPONENT_H
#define QRK_COMPONENT_H

/*!
  \file
  \brief コンポーネントのインターフェース定義

  \author Satofumi KAMIMURA

  $Id: Component.h 1835 2010-05-23 21:01:58Z satofumi $
*/

#include "Rect.h"
#include "Point.h"


namespace qrk
{
    class Angle;


    //! コンポーネントのインターフェース定義
    class Component
    {
    public:
        virtual ~Component(void)
        {
        }


        virtual void setPosition(const Point<long>& position)
        {
            position_ = position;
        }


        virtual Point<long> position(void) const
        {
            return position_;
        }


        virtual Rect<long> rect(void) const = 0;


        /*!
          \brief イベントの受け付け管理

          登録済みのイベントの受け付けを 許可 / 禁止 できる。

          \param[in] acceptable イベントを受け付けるかどうか
        */
        virtual void setEventAcceptable(bool acceptable) = 0;
        virtual void setAlpha(float alpha) = 0;
        virtual float alpha(void) = 0;
        virtual void setRotateAngle(const Angle& angle) = 0;
        virtual void draw(const Rect<long>& area) = 0;

    private:
        Point<long> position_;
    };
}

#endif /* !QRK_COMPONENT_H */
