#ifndef QRK_CHECK_BOX_H
#define QRK_CHECK_BOX_H

/*!
  \file
  \brief コンボボックス

  \author Satofumi KAMIMURA

  $Id: CheckBox.h 1828 2010-05-19 21:47:54Z satofumi $
*/

#include "Component.h"
#include <memory>


namespace qrk
{
    class Surface;
    class Color;


    class CheckBox : public Component
    {
    public:
        explicit CheckBox(const Rect<long>& rect, Surface& text,
                          Surface& check_image, Surface& no_check_image);
        ~CheckBox(void);

        Rect<long> rect(void) const;
        void setEventAcceptable(bool acceptable);
        void setAlpha(float alpha);
        float alpha(void);
        void setRotateAngle(const Angle& angle);
        void draw(const Rect<long>& area);

        void setFocusedColor(const Color& color);

    private:
        CheckBox(const CheckBox& rhs);
        CheckBox& operator = (CheckBox& rhs);

        struct pImpl;
        std::auto_ptr<pImpl> pimpl;
    };
}

#endif /* !QRK_CHECK_BOX_H */
