/*!
  \file
  \brief コンボボックス

  \author Satofumi KAMIMURA

  $Id: CheckBox.cpp 1828 2010-05-19 21:47:54Z satofumi $
*/

#include "CheckBox.h"
#include "Color.h"

using namespace qrk;


struct CheckBox::pImpl
{
    Rect<long> rect_;
    Surface& text_;
    Surface& check_image_;
    Surface& no_check_image_;
    Color focused_color_;
    float alpha_;


    pImpl(const Rect<long>& rect, Surface& text,
          Surface& check_image, Surface& no_check_image)
        : rect_(rect), text_(text), check_image_(check_image),
          no_check_image_(no_check_image),
          focused_color_(Color(0.0, 0.0, 0.0, 0.0)), alpha_(1.0f)
    {
    }
};


CheckBox::CheckBox(const Rect<long>& rect, Surface& text,
                   Surface& check_image, Surface& no_check_image)
    : pimpl(new pImpl(rect, text, check_image, no_check_image))
{
}


CheckBox::~CheckBox(void)
{
}


Rect<long> CheckBox::rect(void) const
{
    return pimpl->rect_;
}


void CheckBox::setEventAcceptable(bool acceptable)
{
    (void)acceptable;
    // !!!
}


void CheckBox::setAlpha(float alpha)
{
    pimpl->alpha_ = alpha;
}


float CheckBox::alpha(void)
{
    return pimpl->alpha_;
}


void CheckBox::setRotateAngle(const Angle& angle)
{
    (void)angle;
    // !!!
}


void CheckBox::draw(const Rect<long>& area)
{
    (void)area;
    // !!!
}


void CheckBox::setFocusedColor(const Color& color)
{
    pimpl->focused_color_ = color;
}
