#ifndef QRK_CHANGE_SELECT_H
#define QRK_CHANGE_SELECT_H

/*!
  \file
  \brief 項目の表示を入れ換えて決定を促す選択コンポーネント

  \author Satofumi KAMIMURA

  $Id: ChangeSelect.h 1940 2011-01-23 22:56:38Z satofumi $
*/

#include "Component.h"
#include <memory>


namespace qrk
{
    class ChangeSelect : public Component
    {
    public:
        ChangeSelect(void);
        ~ChangeSelect(void);

        Rect<long> rect(void) const;
        void setEventAcceptable(bool acceptable);
        void setAlpha(float alpha);
        float alpha(void);
        void setRotateAngle(const Angle& angle);
        void draw(const Rect<long>& area);

    private:
        ChangeSelect(const ChangeSelect& rhs);
        ChangeSelect& operator = (const ChangeSelect& rhs);

        struct pImpl;
        std::auto_ptr<pImpl> pimpl;
    };
}

#endif /* !QRK_CHANGE_SELECT_H */
