/*!
  \file
  \brief LeastSquare のテスト

  \author Satofumi KAMIMURA

  $Id: TestLeastSquare.cpp 1811 2010-04-30 16:12:05Z satofumi $
*/

#include "TestLeastSquare.h"
#include "leastSquare.h"
#include <cstring>

using namespace qrk;
using namespace std;


CPPUNIT_TEST_SUITE_REGISTRATION(TestLeastSquare);
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(TestLeastSquare, "TestLeastSquare");


void TestLeastSquare::compileTest(void)
{
    double a;
    double b;
    vector<Point<long> > points;
    leastSquare<long>(a, b, &points[0], points.size());
}


void TestLeastSquare::abTest(void)
{
    double a;
    double b;
    vector<Point<long> > points;

    // a = 0.0, b = 1.0
    points.push_back(Point<long>(0, 1));
    points.push_back(Point<long>(1, 1));
    points.push_back(Point<long>(2, 1));
    points.push_back(Point<long>(3, 1));

    leastSquare<long>(a, b, &points[0], points.size());
    CPPUNIT_ASSERT_EQUAL(0.0, a);
    CPPUNIT_ASSERT_EQUAL(1.0, b);

    // a = 1.0, b = -1.0
    points.clear();
    points.push_back(Point<long>(0, -1));
    points.push_back(Point<long>(1, 0));
    points.push_back(Point<long>(2, 1));
    points.push_back(Point<long>(3, 2));

    leastSquare<long>(a, b, &points[0], points.size());
    CPPUNIT_ASSERT_EQUAL(1.0, a);
    CPPUNIT_ASSERT_EQUAL(-1.0, b);

    // a = -1.0, b = -1.0
    points.clear();
    points.push_back(Point<long>(0, -1));
    points.push_back(Point<long>(1, -2));
    points.push_back(Point<long>(2, -3));
    points.push_back(Point<long>(3, -4));

    leastSquare<long>(a, b, &points[0], points.size());
    CPPUNIT_ASSERT_EQUAL(-1.0, a);
    CPPUNIT_ASSERT_EQUAL(-1.0, b);
}
