/*!
  \file
  \brief 角度の補助関数

  \author Satofumi KAMIMURA

  $Id: AngleUtils.cpp 1811 2010-04-30 16:12:05Z satofumi $
*/

#include "AngleUtils.h"

using namespace qrk;


Angle qrk::narrowAngles(const Angle& a, const Angle& b)
{
    Angle diff = a - b;

    // !!! to_deg() を削除し、while でなく計算で処理するようにする
    while (diff.to_deg() > 180) {
        diff -= deg(360);
    }
    while (diff.to_deg() < -180) {
        diff += deg(360);
    }

    return diff;
}
