/*!
  \file
  \brief SCI の出力補助

  \author Satofumi KAMIMURA

  $Id: sci_put.c 1811 2010-04-30 16:12:05Z satofumi $
*/

#include "sci_put.h"
#include "sci_control.h"


int sci_putc(const char ch)
{
    sci_send(&ch, 1);
    return ch;
}


int sci_puts(const char* data)
{
    const char *p;
    for (p = data; *p != '\0'; ++p) {
        ;
    }
    return sci_send(data, p - data);
}


int sci_putint(long value)
{
    char buffer[] = { '\0', '\0', '\0', '\0',
                      '\0', '\0', '\0', '\0',
                      '\0', '\0', '\0', '\0', '\0' };
    int sign = -1;
    int index = 11;
    long calc_value = value;

    if (calc_value >= 0) {
        // 負の値の方が、表現できる数値が１大きいため、負の数で計算する
        calc_value = -calc_value;
        sign = +1;
    }

    do {
        buffer[index--] = '0' - (calc_value % 10);
        calc_value /= 10;
    } while (calc_value != 0);

    if (sign < 0) {
        buffer[index--] = '-';
    }
    ++index;

    return sci_puts(&buffer[index]);
}


int sci_puthex(unsigned long value, int byte_size)
{
    char buffer[] = "12345678";
    unsigned long left_value = value;
    int i;

    for (i = 0; i < 8; ++i) {
        int num = left_value & 0xf;
        buffer[7 - i] = num + ((num <= 9) ? '0' : ('a' - 10));
        left_value >>= 4;
    }
    return sci_puts(&buffer[8 - (byte_size << 1)]);
}
