/*!
  \example mot_parse の動作サンプル

  \author Satofumi KAMIMURA

  $Id: mot_handler_output.c 1811 2010-04-30 16:12:05Z satofumi $
*/

#include "mot_handler.h"
#include <stdio.h>
#include <stdbool.h>
#include <string.h>


static bool isLF(const char ch)
{
    return ((ch == '\r') || (ch == '\n')) ? true : false;
}


int main(int argc, char *argv[])
{
    (void)argc;
    (void)argv;

    FILE* fd = fopen("sample.mot", "r");
    if (! fd) {
        perror("");
        return 1;
    }

    enum { BufferSize = 80 };
    char buffer[BufferSize];
    while (fgets(buffer, BufferSize, fd)) {
        printf("%s", buffer);

        // 最後の１文字が改行ならば取り除く
        int n = strlen(buffer);
        if (isLF(buffer[n - 1])) {
            buffer[n - 1] = '\0';
        }

        mot_t mot;
        int type = mot_parse(&mot, buffer);
        printf("type: %d, ", type);
        printf("address: %08lx, ", mot.address);
        printf("data_size: %d, ", mot.data_size);

        int i;
        for (i = 0; i < mot.data_size; ++i) {
            printf("%02x ", (unsigned char)mot.data[i]);
        }
        printf("\n");
    }

    return 0;
}
