/*!
  \file
  \brief SciPut のテスト

  \author Satofumi KAMIMURA

  $Id: TestSciPut.cpp 1703 2010-02-17 16:52:32Z satofumi $
*/

#include "TestSciPut.h"
#include "sci_put.h"
#include "sci_control.h"
#include <cstring>

extern std::string sci_buffer(void);
extern void sci_clearBuffer(void);

using namespace std;


CPPUNIT_TEST_SUITE_REGISTRATION(TestSciPut);
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(TestSciPut, "TestSciPut");


void TestSciPut::putintTest(void)
{
  sci_putint(12345);
  string buffer = sci_buffer();
  sci_clearBuffer();
  CPPUNIT_ASSERT_EQUAL(string("12345"), buffer);

  sci_putint(99);
  buffer = sci_buffer();
  sci_clearBuffer();
  CPPUNIT_ASSERT_EQUAL(string("99"), buffer);
}
