/*!
  \example controller/samples/usbJoystickSample.cpp

  UsbJoystick の動作サンプル

  ジョイスティックへの入力情報を出力する。

  - 出力している内容
    - 軸の値
    - ボタンの押下

  \verbatim
!!! 実行結果の例 \endverbatim \n


  \author Satofumi KAMIMURA

  $Id: usbJoystickSample.cpp 1474 2009-11-01 05:33:08Z satofumi $

  ViewJoystickInfo.cpp
  \include ViewJoystickInfo.cpp
*/

#include "UsbJoystick.h"
#include "ViewJoystickInfo.h"
#include <cstdio>
#include <cstdlib>

using namespace qrk;


int main(int argc, char *argv[])
{
  // 最初に認識した Joystick と接続を確立する
  UsbJoystick joystick;
  if (! joystick.connect()) {
    printf("UsbJoystick::connect: %s\n", joystick.what());
    exit(1);
  }
  printf("Found joystick: %d\n", joystick.joystickNum());

  // ジョイスティック情報の取得、表示
  ViewJoystickInfo(joystick);

  return 0;
}
