/*!
  \file
  \brief SDL 対応ジョイスティックの初期化

  \author Satofumi KAMIMURA

  $Id: SdlJoystickInit.cpp 1330 2009-09-21 18:26:26Z satofumi $

  \todo LogManager 対応
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "SdlJoystickInit.h"
#include "SdlVideoInit.h"
#include <SDL.h>

using namespace qrk;


/*!
  \brief SdlJoystickInit の内部クラス
*/
struct SdlJoystickInit::pImpl : private SdlVideoInit
{
  static bool initialized;

  static void joystickQuit(void) {
    SDL_QuitSubSystem(SDL_INIT_JOYSTICK);
  }
};

bool SdlJoystickInit::pImpl::initialized = false;


SdlJoystickInit::SdlJoystickInit(void) : pimpl(new pImpl)
{
  if (pimpl->initialized == false) {
    if (SDL_InitSubSystem(SDL_INIT_JOYSTICK)) {
      // !!! LogManager へのメッセージ表示
      return;
    }
    SDL_InitSubSystem(SDL_INIT_VIDEO);
    atexit(pImpl::joystickQuit);
    SDL_JoystickEventState(SDL_ENABLE);
    pimpl->initialized = true;
  }
}


SdlJoystickInit::~SdlJoystickInit(void) {
}
