/*!
  \file
  \brief サーバ側

  \author Satofumi KAMIMURA

  $Id: ServerThread.cpp 1138 2009-07-13 10:40:08Z satofumi $
*/

#include "ServerThread.h"
#include "port.h"
#include <QTcpServer>
#include <QApplication>


struct ServerThread::pImpl
{
  QTcpServer tcp_server_;


  pImpl(void)
  {
    tcp_server_.listen(QHostAddress::Any, Port);
  }
};


ServerThread::ServerThread(void) : pimpl(new pImpl)
{
}


ServerThread::~ServerThread(void)
{
}


void ServerThread::run(void)
{
  fprintf(stderr, "QApplication thread: %p\n", QApplication::instance()->thread());

  fprintf(stderr, "server thread: %p\n", this);
  fprintf(stderr, "tcp_server_: %p\n", &pimpl->tcp_server_);

  pimpl->tcp_server_.moveToThread(QApplication::instance()->thread());

  enum { Timeout = 1000 };
  if (! pimpl->tcp_server_.waitForNewConnection(Timeout)) {
    fprintf(stderr, "server: no connection.\n");
    return;
  }

  // !!!
}
