/*!
  \example findComPortsSample.cpp

  \brief FindComPorts の動作サンプル

  \author Satofumi KAMIMURA

  $Id: findComPortsSample.cpp 1576 2009-12-15 00:40:56Z satofumi $
*/

#include "FindComPorts.h"
#include <cstdio>

using namespace qrk;
using namespace std;


//! main
int main(int argc, char *argv[])
{
  FindComPorts find_com_ports;

  vector<string> ports;
  find_com_ports.find(ports);

  printf("found ports: %d\n", ports.size());
  for (vector<string>::iterator it = ports.begin(); it != ports.end(); ++it) {
    printf("%s\n", it->c_str());
  }
  printf("\n");


  ports.clear();
  vector<string> drivers;
  find_com_ports.find(ports, drivers);

  printf("found ports: %d\n", ports.size());
  size_t n = ports.size();
  for (size_t i = 0; i < n; ++i) {
    printf("%s (%s)\n", ports[i].c_str(), drivers[i].c_str());
  }


  return 0;
}
