/*!
  \file
  \brief 標準入出力

  \author Satofumi KAMIMURA

  $Id: StandardIo_win.cpp 1811 2010-04-30 16:12:05Z satofumi $
*/

#include "StandardIo.h"
#include <delay.h>
#include <string>

using namespace qrk;
using namespace std;


struct StandardIo::pImpl
{
    string error_message_;
    // !!!


    pImpl(void)
    {
    }
};


StandardIo::StandardIo(void) : pimpl(new pImpl)
{
}


StandardIo::~StandardIo(void)
{
}


const char* StandardIo::what(void) const
{
    return pimpl->error_message_.c_str();
}


bool StandardIo::connect(const char* device, long baudrate)
{
    static_cast<void>(device);
    static_cast<void>(baudrate);

    // 実装しない

    return true;
}


void StandardIo::disconnect(void)
{
    // 実装しない
}


bool StandardIo::setBaudrate(long baudrate)
{
    static_cast<void>(baudrate);

    // 実装しない
    return true;
}


long StandardIo::baudrate(void) const
{
    // 実装しない
    return 0;
}


bool StandardIo::isConnected(void) const
{
    return true;
}


int StandardIo::send(const char* data, size_t count)
{
    (void)data;
    (void)count;

    // !!!

    return -1;
}


int StandardIo::receive(char* data, size_t count, int timeout)
{
    (void)data;
    (void)count;
    (void)timeout;

    // !!!
    delay(timeout);

    return -1;
}


size_t StandardIo::size(void) const
{
    // 実装しない
    return 0;
}


void StandardIo::flush(void)
{
    // !!!
}


void StandardIo::clear(void)
{
    // 実装しない
}


void StandardIo::ungetc(const char ch)
{
    (void)ch;

    // std::ungetc(ch, stdin);
    // !!!
}
