/*!
  \file
  \brief split のテスト

  \author Satofumi KAMIMURA

  $Id: TestSplit.cpp 1811 2010-04-30 16:12:05Z satofumi $
*/

#include "TestSplit.h"
#include "split.h"

CPPUNIT_TEST_SUITE_REGISTRATION(TestSplit);
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(TestSplit, "TestSplit");

using namespace qrk;
using namespace std;


void TestSplit::splitTest(void)
{
    // 基本分割
    vector<string> token;
    size_t n = split(token, "a b cd efg");
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(4), n);
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(4), token.size());
    CPPUNIT_ASSERT_EQUAL(string("a"), token[0]);
    CPPUNIT_ASSERT_EQUAL(string("b"), token[1]);
    CPPUNIT_ASSERT_EQUAL(string("cd"), token[2]);
    CPPUNIT_ASSERT_EQUAL(string("efg"), token[3]);

    // CSV 分割
    token.clear();
    n = split(token, "a ,b, cd,\tefg", ", \t");
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(4), n);
    CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(4), token.size());
    CPPUNIT_ASSERT_EQUAL(string("a"), token[0]);
    CPPUNIT_ASSERT_EQUAL(string("b"), token[1]);
    CPPUNIT_ASSERT_EQUAL(string("cd"), token[2]);
    CPPUNIT_ASSERT_EQUAL(string("efg"), token[3]);
}
