/*!
  \file
  \brief SoundEffect の利用サンプル

  \author Satofumi KAMIMURA

  $Id: SoundEffectSample.cpp 1966 2011-08-16 08:57:00Z satofumi $
*/

#include "Audio.h"
#include "SoundEffect.h"
#include "delay.h"
#include <iostream>
#include <cstdlib>
#include <SDL.h>

using namespace qrk;
using namespace std;


int main(int argc, char *argv[])
{
    const char* play_file = "effect.wav";
    if (argc >= 2) {
        play_file = argv[1];
    }

    Audio audio;
    if (! audio.initialize()) {
        cout << audio.what() << endl;
        exit(1);
    }

    SoundEffect sound_effect(play_file);
    sound_effect.play();

    while (sound_effect.isPlaying()) {
        delay(100);
    }

    return 0;
}
