/*!
  \file
  \brief SDL_mixer の初期化

  \author Satofumi KAMIMURA

  $Id: SdlMixerInit.cpp 1811 2010-04-30 16:12:05Z satofumi $
*/

#include "SdlAudioInit.h"
#include "SdlMixerInit.h"
#include <SDL_mixer.h>

using namespace qrk;

namespace
{
    void cleanup(void)
    {
        Mix_AllocateChannels(0);
        Mix_CloseAudio();
    }
}


struct SdlMixerInit::pImpl : private SdlAudioInit
{
    static bool initialized_;
};
bool SdlMixerInit::pImpl::initialized_ = false;


SdlMixerInit::SdlMixerInit(void) : pimpl(new pImpl)
{
}


SdlMixerInit::~SdlMixerInit(void)
{
}


bool SdlMixerInit::initialize(void)
{
    if (pimpl->initialized_) {
        return true;
    }

    if (Mix_OpenAudio(MIX_DEFAULT_FREQUENCY,
                      MIX_DEFAULT_FORMAT, MIX_DEFAULT_CHANNELS, 1024) < 0) {
        return false;
    }
    atexit(Mix_CloseAudio);

    enum { ChannelSize = 8 };
    Mix_AllocateChannels(ChannelSize);
    atexit(cleanup);

    pimpl->initialized_ = true;
    return true;
}


bool SdlMixerInit::isInitialized(void)
{
    return pimpl->initialized_;
}
