#ifndef QRK_SOUND_EFFECT_H
#define QRK_SOUND_EFFECT_H

/*!
  \file
  \brief 効果音の再生

  \author Satofumi KAMIMURA

  $Id: SoundEffect.h 1964 2011-08-12 19:16:24Z satofumi $
*/

#include <memory>
#include <cstddef>


namespace qrk
{
    //! 効果音の再生
    class SoundEffect
    {
    public:
        explicit SoundEffect(const char* play_file);
        ~SoundEffect(void);

        void setMute(bool is_mute);
        bool isMute(void) const;

        void setMasterVolume(size_t percent);

        /*!
          \brief ボリュームの設定

          実際に再生される効果音のボリュームは setMasterVolume() と setVolume() で設定される値の積になる。
        */
        void setVolume(size_t percent);

        void play(float x = 0.0, float y = 0.0, float z = 0.1);
        void stop(void);
        void updatePosition(float x, float y, float z = 0.1);
        bool isPlaying(void) const;

    private:
        SoundEffect(void);
        SoundEffect(const SoundEffect& rhs);
        SoundEffect& operator = (const SoundEffect& rhs);

        struct pImpl;
        std::auto_ptr<pImpl> pimpl;
    };
}

#endif /* !QRK_SOUND_EFFECT_H */
